package jel.com.effects
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	public class EfectoHumo extends Sprite
	{
		private var _width:Number;
		private var _height:Number;
		
		private var contenedor_mc:Sprite;
		private var estado:Boolean = false;
		
		private var vidaTot:Number = 100;
		
		public function EfectoHumo(_width:Number, _height:Number) {
			this._width = _width;
			this._height = _height;
			
			var fondo:Sprite = new Sprite();
			fondo.graphics.beginFill(0x000000, 1.0);
			fondo.graphics.drawRect(0,0, _width, _height);
			fondo.graphics.endFill();
			this.addChild(fondo);
			
			contenedor_mc = new Sprite();
			this.addChild(contenedor_mc);
			
			this.addEventListener(Event.ENTER_FRAME, enterFrame);
			this.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown)
			this.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
			
			this.buttonMode = true;
		}
		
		private function mouseDown(evt:MouseEvent):void {
			estado = true;
		}
		
		private function mouseUp(evt:MouseEvent):void {
			estado = false;
		}
		
		private function numAleatorio(min:Number, max:Number):Number {
			return (min + (max - min + 1)*Math.random());
		}
		
		private function creaHumo():void {
			
			var nivelAlpha:Number = 0.9;
			var radio:Number = 20+35*Math.random();
			var particula:Particula = new Particula(radio, 0xdddddd, nivelAlpha*(0.5+0.5*Math.random()), numAleatorio(3,6), numAleatorio(30, 90));
			particula.x = this.mouseX;
			particula.y = this.mouseY;
			particula.scaleY = 1.15;
			particula.vida = 0;
			
			contenedor_mc.addChild(particula);
			
		}
		
		private function actualizaHumo():void {
			var particula:Particula;
			for (var i:uint=0; i< contenedor_mc.numChildren; i++) {
				particula = Particula(contenedor_mc.getChildAt(i));
				particula.x += Math.cos(particula.y / particula.curva);
				particula.y -=  particula.vel;
 				particula.vida += 1;
				particula.alpha = particula._alphaInic*(1-particula.vida/vidaTot);
				if (particula.vida>vidaTot) {
					contenedor_mc.removeChild(particula);
				}
			}
		}
		
		private function enterFrame(evt:Event):void {
			if (estado) {
				creaHumo();
			}
			actualizaHumo();
		}
	}
}